<!DOCTYPE html>
<html lang="en">

<head>
    <style>
        body {
            font-size: 11px;
            font-family: sans-serif;
            text-transform: uppercase;
        }

        table {

            border-collapse: collapse;
            width: 100%;
            padding-bottom: 10px;
            padding-top: 0px;
        }

        td,
        th {
            border: 1px solid #ddd;
            padding: 4px;
            font-size: 12px;
        }

        tr:nth-child(even) {
            background-color: #f2f2f2;
        }

        th {
            /*    padding-top: 12px;
                padding-bottom: 12px;*/
            text-align: left;
            background-color: #f4f9f3;
            color: black;
        }

        .double_hr {
            overflow: visible;
            /* For IE */
            padding: 0;
            border: none;
            border-top: medium double #333;
            color: #333;
            text-align: center;
            margin-bottom: 10px;
        }

        hr {
            margin: 3px;
        }

        .table_title {
            margin-bottom: 0px;
            padding-bottom: 5px;
        }

        .logo {
            margin-right: 30px;
            margin-bottom: 25px;
        }
    </style>

</head>

<body>
    {!! getLogo() !!}
    <H2>CUSTOMER TRANSACTION HISTORY REPORT</H2>
    <p>Filtered by:</p>
    <p>From Date : {{ $from_date ?? '' }} | To Date : {{ $end_date ?? '' }}</p>
    <p>Customer : {{ $customer_name ?? '' }} | Area : {{ $city ?? '' }} | Rep : {{ $rep ?? '' }}</p>
    @php
        $total_credit = 0;
        $total_debit = 0;
        $total_balance = 0;
    @endphp
    <table style="width: 100%;">
        <tr>
            <th style="width: 12%;">Ref #</th>
            <th style="width: 12%;">Date</th>
            <th style="width: 10%;">Description</th>
            <th style="width: 18%;">Remarks</th>
            <th style="width: 16%; text-align: right;">Credit</th>
            <th style="width: 16%; text-align: right;">Debit</th>
            <th style="width: 16%; text-align: right;">Balance</th>
        </tr>
    </table>
    @foreach ($customers as $customer)
        @if (count($customer['invoices']) > 0)
            <strong>Debator: </strong> {{ $customer['company_name'] ?? '' }} | <strong>City: </strong>
            {{ $customer['area']['name_en'] ?? '' }} <br>
            <hr>
            @php
                $invoice_credit = 0;
                $invoice_debit = 0;
            @endphp
            <table style="width: 100%;">
                @foreach ($customer['invoices'] as $invoice)
                    @php
                        $total_credit += $invoice['total'];
                        $invoice_credit += $invoice['total'];
                        $invoice_total = $invoice['total'];
                    @endphp
                    <tr>
                        <td style="width: 12%;">{{ $invoice['invoice_code'] }}</td>
                        <td style="width: 12%;">
                            @php
                                $count_days = \Carbon\Carbon::parse($invoice['invoice_date'])->diffInDays(\Carbon\Carbon::now(), false);
                            @endphp
                            {{ $invoice['invoice_date'] }}
                        </td>
                        <td style="width: 10%;">Sale</td>
                        <td style="width: 18%;">{{ $invoice['remarks'] }}</td>
                        <td style="width: 16%; text-align: right;">
                            {{ \App\Http\Helper::formatPrice($invoice['total']) }}
                        </td>
                        <td style="width: 16%; text-align: right;">
                            {{ \App\Http\Helper::formatPrice(0) }}
                        </td>
                        <td style="width: 16%; text-align: right;">
                            {{ \App\Http\Helper::formatPrice($invoice['total']) }}
                    </tr>
                    @foreach ($invoice['invoice_payments'] as $invoice_payment)
                        @if ($invoice_payment['status'] == 1)
                            @php
                                $total_debit += $invoice_payment['payment_amount'];
                                $invoice_debit += $invoice_payment['payment_amount'];
                                $invoice_total -= $invoice_payment['payment_amount'];
                            @endphp
                            <tr>
                                <td style="width: 12%;">{{ $invoice_payment['payment_code'] }}</td>
                                <td style="width: 12%;">
                                    @php
                                        $count_days = \Carbon\Carbon::parse($invoice_payment['cheque_date'])->diffInDays(\Carbon\Carbon::now(), false);
                                    @endphp
                                    {{ $invoice_payment['payment_date'] }}
                                </td>
                                <td style="width: 10%;">Payment</td>
                                <td style="width: 18%;">{{ $invoice_payment['payment_remarks'] }}</td>
                                <td style="width: 16%; text-align: right;">{{ \App\Http\Helper::formatPrice(0) }}
                                </td>
                                <td style="width: 16%; text-align: right;">
                                    {{ \App\Http\Helper::formatPrice($invoice_payment['payment_amount']) }}
                                </td>
                                <td style="width: 16%; text-align: right;">
                                    {{ \App\Http\Helper::formatPrice($invoice_total) }}
                                </td>
                            </tr>
                        @endif
                    @endforeach
                    @php
                        $credit_notes = \Illuminate\Support\Facades\DB::table('invoice_return')->where('deduct_invoice_id', $invoice['id'])->get();
                    @endphp
                    @foreach ($credit_notes as $invoice_return)
{{--                        @foreach ($invoice->invoice_returns as $invoice_return)--}}

                        @if ($invoice_return->status == 'A' && $invoice_return->deleted_at == '')
                            @php
                                $total_debit += $invoice_return->balance;
                                $invoice_debit += $invoice_return->balance;
                                $invoice_total -= $invoice_return->balance;
                            @endphp
                            <tr>
                                <td style="width: 12%;">{{ $invoice_return->invoice_return_code }}</td>
                                <td style="width: 12%;">
                                    @php
                                        $count_days = \Carbon\Carbon::parse($invoice_return->invoice_return_date)->diffInDays(\Carbon\Carbon::now(), false);
                                    @endphp
                                    {{ $invoice_return->invoice_return_date }}
                                </td>
                                <td style="width: 10%;">Credit Note</td>
                                <td style="width: 18%;">{{ $invoice_return->remarks }}</td>
                                <td style="width: 16%; text-align: right;">{{ \App\Http\Helper::formatPrice(0) }}
                                </td>
                                <td style="width: 16%; text-align: right;">
                                    {{ \App\Http\Helper::formatPrice($invoice_return->balance) }}
                                </td>
                                <td style="width: 16%; text-align: right;">
                                    {{ \App\Http\Helper::formatPrice($invoice_total) }}
                                </td>
                            </tr>
                        @endif
                    @endforeach
                    @foreach ($invoice['bulk_discount_invoices'] as $discount_invoice)
                        @php
                            $total_debit += $discount_invoice['discount'];
                            $invoice_debit += $discount_invoice['discount'];
                            $invoice_total -= $discount_invoice['discount'];

                            $bulk_discount = \App\BulkDiscountModel::find($discount_invoice['bulk_discount_id'])

                        @endphp
                        <tr>
                            <td style="width: 12%;">{{ $bulk_discount->invoice_code }}</td>
                            <td style="width: 12%;">
                                @php
                                    $count_days = \Carbon\Carbon::parse($bulk_discount->date)->diffInDays(\Carbon\Carbon::now(), false);
                                @endphp
                                {{ \Carbon\Carbon::parse($bulk_discount->date)->format('Y-m-d') }}
                            </td>
                            <td style="width: 10%;">Discount & Credit</td>
                            <td style="width: 18%;">{{ $bulk_discount->remarks }}</td>
                            <td style="width: 16%; text-align: right;">{{ \App\Http\Helper::formatPrice(0) }}
                            </td>
                            <td style="width: 16%; text-align: right;">
                                {{ \App\Http\Helper::formatPrice($discount_invoice['discount']) }}
                            </td>
                            <td style="width: 16%; text-align: right;">
                                {{ \App\Http\Helper::formatPrice($invoice_total) }}
                            </td>
                        </tr>
                    @endforeach
                @endforeach
            </table>
            <hr class="double_hr">
        @endif
    @endforeach
</body>

</html>
